/*!
 * JustGage - animated gauges using RaphaelJS
 * Check http://www.justgage.com for official releases
 * Licensed under MIT. 
 * @author Bojan Djuricic (@Toorshia)
 */
;JustGage=function(F){var m=this;if(F===null||F===undefined){console.log("* justgage: Make sure to pass options to the constructor!");return false}var v;if(F.id!==null&&F.id!==undefined){v=document.getElementById(F.id);if(!v){console.log("* justgage: No element with id : %s found",F.id);return false}}else{if(F.parentNode!==null&&F.parentNode!==undefined){v=F.parentNode}else{console.log("* justgage: Make sure to pass the existing element id or parentNode to the constructor.");return false}}var g=v.dataset?v.dataset:{};var h=(F.defaults!==null&&F.defaults!==undefined)?F.defaults:false;if(h!==false){F=extend({},F,h);delete F.defaults}m.config={id:F.id,value:kvLookup("value",F,g,0,"float"),defaults:kvLookup("defaults",F,g,0,false),parentNode:kvLookup("parentNode",F,g,null),width:kvLookup("width",F,g,null),height:kvLookup("height",F,g,null),title:kvLookup("title",F,g,""),titleFontColor:kvLookup("titleFontColor",F,g,"#999999"),valueFontColor:kvLookup("valueFontColor",F,g,"#010101"),symbol:kvLookup("symbol",F,g,""),min:kvLookup("min",F,g,0,"float"),max:kvLookup("max",F,g,100,"float"),reverse:kvLookup("reverse",F,g,false),humanFriendlyDecimal:kvLookup("humanFriendlyDecimal",F,g,0),textRenderer:kvLookup("textRenderer",F,g,null),gaugeWidthScale:kvLookup("gaugeWidthScale",F,g,1),gaugeColor:kvLookup("gaugeColor",F,g,"#edebeb"),label:kvLookup("label",F,g,""),labelFontColor:kvLookup("labelFontColor",F,g,"#b3b3b3"),shadowOpacity:kvLookup("shadowOpacity",F,g,0.2),shadowSize:kvLookup("shadowSize",F,g,5),shadowVerticalOffset:kvLookup("shadowVerticalOffset",F,g,3),levelColors:kvLookup("levelColors",F,g,["#a9d70b","#f9c802","#ff0000"],"array",","),startAnimationTime:kvLookup("startAnimationTime",F,g,700),startAnimationType:kvLookup("startAnimationType",F,g,">"),refreshAnimationTime:kvLookup("refreshAnimationTime",F,g,700),refreshAnimationType:kvLookup("refreshAnimationType",F,g,">"),donutStartAngle:kvLookup("donutStartAngle",F,g,90),valueMinFontSize:kvLookup("valueMinFontSize",F,g,16),titleMinFontSize:kvLookup("titleMinFontSize",F,g,10),labelMinFontSize:kvLookup("labelMinFontSize",F,g,10),minLabelMinFontSize:kvLookup("minLabelMinFontSize",F,g,10),maxLabelMinFontSize:kvLookup("maxLabelMinFontSize",F,g,10),hideValue:kvLookup("hideValue",F,g,false),hideMinMax:kvLookup("hideMinMax",F,g,false),hideInnerShadow:kvLookup("hideInnerShadow",F,g,false),humanFriendly:kvLookup("humanFriendly",F,g,false),noGradient:kvLookup("noGradient",F,g,false),donut:kvLookup("donut",F,g,false),relativeGaugeSize:kvLookup("relativeGaugeSize",F,g,false),counter:kvLookup("counter",F,g,false),decimals:kvLookup("decimals",F,g,0),customSectors:kvLookup("customSectors",F,g,[]),formatNumber:kvLookup("formatNumber",F,g,false),pointer:kvLookup("pointer",F,g,false),pointerOptions:kvLookup("pointerOptions",F,g,[])};var d,u,c,o,r,l,i,z,q,p,n,w,t,b,f,e,k,D,C,j,B,A;if(m.config.value>m.config.max){m.config.value=m.config.max}if(m.config.value<m.config.min){m.config.value=m.config.min}m.originalValue=kvLookup("value",F,g,-1,"float");if(m.config.id!==null&&(document.getElementById(m.config.id))!==null){m.canvas=Raphael(m.config.id,"100%","100%")}else{if(m.config.parentNode!==null){m.canvas=Raphael(m.config.parentNode,"100%","100%")}}if(m.config.relativeGaugeSize===true){m.canvas.setViewBox(0,0,200,150,true)}if(m.config.relativeGaugeSize===true){d=200;u=150}else{if(m.config.width!==null&&m.config.height!==null){d=m.config.width;u=m.config.height}else{if(m.config.parentNode!==null){m.canvas.setViewBox(0,0,200,150,true);d=200;u=150}else{d=getStyle(document.getElementById(m.config.id),"width").slice(0,-2)*1;u=getStyle(document.getElementById(m.config.id),"height").slice(0,-2)*1}}}if(m.config.donut===true){if(d>u){o=u;c=o}else{if(d<u){c=d;o=c;if(o>u){r=o/u;o=o/r;c=o/r}}else{c=d;o=c}}l=(d-c)/2;i=(u-o)/2;z=((o/8)>10)?(o/10):10;q=l+c/2;p=i+o/11;n=((o/6.4)>16)?(o/5.4):18;w=l+c/2;if(m.config.label!==""){t=i+o/1.85}else{t=i+o/1.7}b=((o/16)>10)?(o/16):10;f=l+c/2;e=t+b;k=((o/16)>10)?(o/16):10;D=l+(c/10)+(c/6.666666666666667*m.config.gaugeWidthScale)/2;C=e;j=((o/16)>10)?(o/16):10;B=l+c-(c/10)-(c/6.666666666666667*m.config.gaugeWidthScale)/2;A=e}else{if(d>u){o=u;c=o*1.25;if(c>d){r=c/d;c=c/r;o=o/r}}else{if(d<u){c=d;o=c/1.25;if(o>u){r=o/u;o=o/r;c=o/r}}else{c=d;o=c*0.75}}l=(d-c)/2;i=(u-o)/2;z=((o/8)>m.config.titleMinFontSize)?(o/10):m.config.titleMinFontSize;q=l+c/2;p=i+o/6.4;n=((o/6.5)>m.config.valueMinFontSize)?(o/6.5):m.config.valueMinFontSize;w=l+c/2;t=i+o/1.275;b=((o/16)>m.config.labelMinFontSize)?(o/16):m.config.labelMinFontSize;f=l+c/2;e=t+n/2+5;k=((o/16)>m.config.minLabelMinFontSize)?(o/16):m.config.minLabelMinFontSize;D=l+(c/10)+(c/6.666666666666667*m.config.gaugeWidthScale)/2;C=e;j=((o/16)>m.config.maxLabelMinFontSize)?(o/16):m.config.maxLabelMinFontSize;B=l+c-(c/10)-(c/6.666666666666667*m.config.gaugeWidthScale)/2;A=e}m.params={canvasW:d,canvasH:u,widgetW:c,widgetH:o,dx:l,dy:i,titleFontSize:z,titleX:q,titleY:p,valueFontSize:n,valueX:w,valueY:t,labelFontSize:b,labelX:f,labelY:e,minFontSize:k,minX:D,minY:C,maxFontSize:j,maxX:B,maxY:A};d,u,c,o,r,l,i,z,q,p,n,w,t,b,f,e,k,D,C,j,B,A=null;m.canvas.customAttributes.pki=function(U,V,X,O,Y,P,N,G,M,L){var J,Q,T,K,I,R,Z,W,H,S;if(M){J=(1-2*(U-V)/(X-V))*Math.PI;Q=O/2-O/7;T=Q-O/6.666666666666667*G;K=O/2+P;I=Y/1.95+N;R=O/2+P+Q*Math.cos(J);Z=Y-(Y-I)-Q*Math.sin(J);W=O/2+P+T*Math.cos(J);H=Y-(Y-I)-T*Math.sin(J);S="M"+(K-T)+","+I+" ";S+="L"+(K-Q)+","+I+" ";if(U>((X-V)/2)){S+="A"+Q+","+Q+" 0 0 1 "+(K+Q)+","+I+" "}S+="A"+Q+","+Q+" 0 0 1 "+R+","+Z+" ";S+="L"+W+","+H+" ";if(U>((X-V)/2)){S+="A"+T+","+T+" 0 0 0 "+(K+T)+","+I+" "}S+="A"+T+","+T+" 0 0 0 "+(K-T)+","+I+" ";S+="Z ";return{path:S}}else{J=(1-(U-V)/(X-V))*Math.PI;Q=O/2-O/10;T=Q-O/6.666666666666667*G;K=O/2+P;I=Y/1.25+N;R=O/2+P+Q*Math.cos(J);Z=Y-(Y-I)-Q*Math.sin(J);W=O/2+P+T*Math.cos(J);H=Y-(Y-I)-T*Math.sin(J);S="M"+(K-T)+","+I+" ";S+="L"+(K-Q)+","+I+" ";S+="A"+Q+","+Q+" 0 0 1 "+R+","+Z+" ";S+="L"+W+","+H+" ";S+="A"+T+","+T+" 0 0 0 "+(K-T)+","+I+" ";S+="Z ";return{path:S}}J,Q,T,K,I,R,Z,W,H,S=null};m.canvas.customAttributes.ndl=function(Z,ab,ad,R,ae,S,Q,G,P){var X=R*3.5/100;var aj=R/15;var T=R/100;if(m.config.pointerOptions.toplength!=null&&m.config.pointerOptions.toplength!=undefined){X=m.config.pointerOptions.toplength}if(m.config.pointerOptions.bottomlength!=null&&m.config.pointerOptions.bottomlength!=undefined){aj=m.config.pointerOptions.bottomlength}if(m.config.pointerOptions.bottomwidth!=null&&m.config.pointerOptions.bottomwidth!=undefined){T=m.config.pointerOptions.bottomwidth}var M,U,Y,N,L,V,ai,ac,H,af,I,O,aa,ah,K,ag,J,W;if(P){M=(1-2*(Z-ab)/(ad-ab))*Math.PI;U=R/2-R/7;Y=U-R/6.666666666666667*G;N=R/2+S;L=ae/1.95+Q;V=R/2+S+U*Math.cos(M);ai=ae-(ae-L)-U*Math.sin(M);ac=R/2+S+Y*Math.cos(M);H=ae-(ae-L)-Y*Math.sin(M);af=V+X*Math.cos(M);I=ai-X*Math.sin(M);O=ac-aj*Math.cos(M);aa=H+aj*Math.sin(M);ah=O+T*Math.sin(M);K=aa+T*Math.cos(M);ag=O-T*Math.sin(M);J=aa-T*Math.cos(M);W="M"+ah+","+K+" ";W+="L"+ag+","+J+" ";W+="L"+af+","+I+" ";W+="Z ";return{path:W}}else{M=(1-(Z-ab)/(ad-ab))*Math.PI;U=R/2-R/10;Y=U-R/6.666666666666667*G;N=R/2+S;L=ae/1.25+Q;V=R/2+S+U*Math.cos(M);ai=ae-(ae-L)-U*Math.sin(M);ac=R/2+S+Y*Math.cos(M);H=ae-(ae-L)-Y*Math.sin(M);af=V+X*Math.cos(M);I=ai-X*Math.sin(M);O=ac-aj*Math.cos(M);aa=H+aj*Math.sin(M);ah=O+T*Math.sin(M);K=aa+T*Math.cos(M);ag=O-T*Math.sin(M);J=aa-T*Math.cos(M);W="M"+ah+","+K+" ";W+="L"+ag+","+J+" ";W+="L"+af+","+I+" ";W+="Z ";return{path:W}}M,U,Y,N,L,V,ai,ac,H,af,I,O,aa,ah,K,ag,J,W=null};m.gauge=m.canvas.path().attr({stroke:"none",fill:m.config.gaugeColor,pki:[m.config.max,m.config.min,m.config.max,m.params.widgetW,m.params.widgetH,m.params.dx,m.params.dy,m.config.gaugeWidthScale,m.config.donut,m.config.reverse]});m.level=m.canvas.path().attr({stroke:"none",fill:getColor(m.config.value,(m.config.value-m.config.min)/(m.config.max-m.config.min),m.config.levelColors,m.config.noGradient,m.config.customSectors),pki:[m.config.min,m.config.min,m.config.max,m.params.widgetW,m.params.widgetH,m.params.dx,m.params.dy,m.config.gaugeWidthScale,m.config.donut,m.config.reverse]});if(m.config.donut){m.level.transform("r"+m.config.donutStartAngle+", "+(m.params.widgetW/2+m.params.dx)+", "+(m.params.widgetH/1.95+m.params.dy))}if(m.config.pointer){m.needle=m.canvas.path().attr({stroke:(m.config.pointerOptions.stroke!==null&&m.config.pointerOptions.stroke!==undefined)?m.config.pointerOptions.stroke:"none","stroke-width":(m.config.pointerOptions.stroke_width!==null&&m.config.pointerOptions.stroke_width!==undefined)?m.config.pointerOptions.stroke_width:0,"stroke-linecap":(m.config.pointerOptions.stroke_linecap!==null&&m.config.pointerOptions.stroke_linecap!==undefined)?m.config.pointerOptions.stroke_linecap:"square",fill:(m.config.pointerOptions.color!==null&&m.config.pointerOptions.color!==undefined)?m.config.pointerOptions.color:"#000000",ndl:[m.config.min,m.config.min,m.config.max,m.params.widgetW,m.params.widgetH,m.params.dx,m.params.dy,m.config.gaugeWidthScale,m.config.donut]});if(m.config.donut){m.needle.transform("r"+m.config.donutStartAngle+", "+(m.params.widgetW/2+m.params.dx)+", "+(m.params.widgetH/1.95+m.params.dy))}}m.txtTitle=m.canvas.text(m.params.titleX,m.params.titleY,m.config.title);m.txtTitle.attr({"font-size":m.params.titleFontSize,"font-weight":"bold","font-family":"Arial",fill:m.config.titleFontColor,"fill-opacity":"1"});setDy(m.txtTitle,m.params.titleFontSize,m.params.titleY);m.txtValue=m.canvas.text(m.params.valueX,m.params.valueY,0);m.txtValue.attr({"font-size":m.params.valueFontSize,"font-weight":"bold","font-family":"Arial",fill:m.config.valueFontColor,"fill-opacity":"0"});setDy(m.txtValue,m.params.valueFontSize,m.params.valueY);m.txtLabel=m.canvas.text(m.params.labelX,m.params.labelY,m.config.label);m.txtLabel.attr({"font-size":m.params.labelFontSize,"font-weight":"normal","font-family":"Arial",fill:m.config.labelFontColor,"fill-opacity":"0"});setDy(m.txtLabel,m.params.labelFontSize,m.params.labelY);var x=m.config.min;if(m.config.reverse){x=m.config.max}m.txtMinimum=x;if(m.config.humanFriendly){m.txtMinimum=humanFriendlyNumber(x,m.config.humanFriendlyDecimal)}else{if(m.config.formatNumber){m.txtMinimum=formatNumber(x)}}m.txtMin=m.canvas.text(m.params.minX,m.params.minY,m.txtMinimum);m.txtMin.attr({"font-size":m.params.minFontSize,"font-weight":"normal","font-family":"Arial",fill:m.config.labelFontColor,"fill-opacity":(m.config.hideMinMax||m.config.donut)?"0":"1"});setDy(m.txtMin,m.params.minFontSize,m.params.minY);var y=m.config.max;if(m.config.reverse){y=m.config.min}m.txtMaximum=y;if(m.config.humanFriendly){m.txtMaximum=humanFriendlyNumber(y,m.config.humanFriendlyDecimal)}else{if(m.config.formatNumber){m.txtMaximum=formatNumber(y)}}m.txtMax=m.canvas.text(m.params.maxX,m.params.maxY,m.txtMaximum);m.txtMax.attr({"font-size":m.params.maxFontSize,"font-weight":"normal","font-family":"Arial",fill:m.config.labelFontColor,"fill-opacity":(m.config.hideMinMax||m.config.donut)?"0":"1"});setDy(m.txtMax,m.params.maxFontSize,m.params.maxY);var a=m.canvas.canvas.childNodes[1];var s="http://www.w3.org/2000/svg";if(ie!=="undefined"&&ie<9){}else{if(ie!=="undefined"){onCreateElementNsReady(function(){m.generateShadow(s,a)})}else{m.generateShadow(s,a)}}a,s=null;if(m.config.textRenderer){m.originalValue=m.config.textRenderer(m.originalValue)}else{if(m.config.humanFriendly){m.originalValue=humanFriendlyNumber(m.originalValue,m.config.humanFriendlyDecimal)+m.config.symbol}else{if(m.config.formatNumber){m.originalValue=formatNumber(m.originalValue)+m.config.symbol}else{m.originalValue=(m.originalValue*1).toFixed(m.config.decimals)+m.config.symbol}}}if(m.config.counter===true){eve.on("raphael.anim.frame."+(m.level.id),function(){var G=m.level.attr("pki")[0];if(m.config.reverse){G=(m.config.max*1)+(m.config.min*1)-(m.level.attr("pki")[0]*1)}if(m.config.textRenderer){m.txtValue.attr("text",m.config.textRenderer(Math.floor(G)))}else{if(m.config.humanFriendly){m.txtValue.attr("text",humanFriendlyNumber(Math.floor(G),m.config.humanFriendlyDecimal)+m.config.symbol)}else{if(m.config.formatNumber){m.txtValue.attr("text",formatNumber(Math.floor(G))+m.config.symbol)}else{m.txtValue.attr("text",(G*1).toFixed(m.config.decimals)+m.config.symbol)}}}setDy(m.txtValue,m.params.valueFontSize,m.params.valueY);G=null});eve.on("raphael.anim.finish."+(m.level.id),function(){m.txtValue.attr({text:m.originalValue});setDy(m.txtValue,m.params.valueFontSize,m.params.valueY)})}else{eve.on("raphael.anim.start."+(m.level.id),function(){m.txtValue.attr({text:m.originalValue});setDy(m.txtValue,m.params.valueFontSize,m.params.valueY)})}var E=m.config.value;if(m.config.reverse){E=(m.config.max*1)+(m.config.min*1)-(m.config.value*1)}m.level.animate({pki:[E,m.config.min,m.config.max,m.params.widgetW,m.params.widgetH,m.params.dx,m.params.dy,m.config.gaugeWidthScale,m.config.donut,m.config.reverse]},m.config.startAnimationTime,m.config.startAnimationType);if(m.config.pointer){m.needle.animate({ndl:[E,m.config.min,m.config.max,m.params.widgetW,m.params.widgetH,m.params.dx,m.params.dy,m.config.gaugeWidthScale,m.config.donut]},m.config.startAnimationTime,m.config.startAnimationType)}m.txtValue.animate({"fill-opacity":(m.config.hideValue)?"0":"1"},m.config.startAnimationTime,m.config.startAnimationType);m.txtLabel.animate({"fill-opacity":"1"},m.config.startAnimationTime,m.config.startAnimationType)};JustGage.prototype.refresh=function(f,a){var e=this;var d,c,a=a||null;if(a!==null){e.config.max=a;e.txtMaximum=e.config.max;if(e.config.humanFriendly){e.txtMaximum=humanFriendlyNumber(e.config.max,e.config.humanFriendlyDecimal)}else{if(e.config.formatNumber){e.txtMaximum=formatNumber(e.config.max)}}if(!e.config.reverse){e.txtMax.attr({text:e.txtMaximum});setDy(e.txtMax,e.params.maxFontSize,e.params.maxY)}else{e.txtMin.attr({text:e.txtMaximum});setDy(e.txtMin,e.params.minFontSize,e.params.minY)}}d=f;if((f*1)>(e.config.max*1)){f=(e.config.max*1)}if((f*1)<(e.config.min*1)){f=(e.config.min*1)}c=getColor(f,(f-e.config.min)/(e.config.max-e.config.min),e.config.levelColors,e.config.noGradient,e.config.customSectors);if(e.config.textRenderer){d=e.config.textRenderer(d)}else{if(e.config.humanFriendly){d=humanFriendlyNumber(d,e.config.humanFriendlyDecimal)+e.config.symbol}else{if(e.config.formatNumber){d=formatNumber((d*1).toFixed(e.config.decimals))+e.config.symbol}else{d=(d*1).toFixed(e.config.decimals)+e.config.symbol}}}e.originalValue=d;e.config.value=f*1;if(!e.config.counter){e.txtValue.attr({text:d});setDy(e.txtValue,e.params.valueFontSize,e.params.valueY)}var b=e.config.value;if(e.config.reverse){b=(e.config.max*1)+(e.config.min*1)-(e.config.value*1)}e.level.animate({pki:[b,e.config.min,e.config.max,e.params.widgetW,e.params.widgetH,e.params.dx,e.params.dy,e.config.gaugeWidthScale,e.config.donut,e.config.reverse],fill:c},e.config.refreshAnimationTime,e.config.refreshAnimationType);if(e.config.pointer){e.needle.animate({ndl:[b,e.config.min,e.config.max,e.params.widgetW,e.params.widgetH,e.params.dx,e.params.dy,e.config.gaugeWidthScale,e.config.donut]},e.config.refreshAnimationTime,e.config.refreshAnimationType)}e,d,c,a=null};JustGage.prototype.generateShadow=function(h,f){var g=this;var a="inner-shadow-"+g.config.id;var j,k,i,e,d,c,b;j=document.createElementNS(h,"filter");j.setAttribute("id",a);f.appendChild(j);k=document.createElementNS(h,"feOffset");k.setAttribute("dx",0);k.setAttribute("dy",g.config.shadowVerticalOffset);j.appendChild(k);i=document.createElementNS(h,"feGaussianBlur");i.setAttribute("result","offset-blur");i.setAttribute("stdDeviation",g.config.shadowSize);j.appendChild(i);e=document.createElementNS(h,"feComposite");e.setAttribute("operator","out");e.setAttribute("in","SourceGraphic");e.setAttribute("in2","offset-blur");e.setAttribute("result","inverse");j.appendChild(e);d=document.createElementNS(h,"feFlood");d.setAttribute("flood-color","black");d.setAttribute("flood-opacity",g.config.shadowOpacity);d.setAttribute("result","color");j.appendChild(d);c=document.createElementNS(h,"feComposite");c.setAttribute("operator","in");c.setAttribute("in","color");c.setAttribute("in2","inverse");c.setAttribute("result","shadow");j.appendChild(c);b=document.createElementNS(h,"feComposite");b.setAttribute("operator","over");b.setAttribute("in","shadow");b.setAttribute("in2","SourceGraphic");j.appendChild(b);if(!g.config.hideInnerShadow){g.canvas.canvas.childNodes[2].setAttribute("filter","url(#"+a+")");g.canvas.canvas.childNodes[3].setAttribute("filter","url(#"+a+")")}j,k,i,e,d,c,b=null};function kvLookup(e,b,h,d,f,c){var g=d;var a=false;if(!(e===null||e===undefined)){if(h!==null&&h!==undefined&&typeof h==="object"&&e in h){g=h[e];a=true}else{if(b!==null&&b!==undefined&&typeof b==="object"&&e in b){g=b[e];a=true}else{g=d}}if(a===true){if(f!==null&&f!==undefined){switch(f){case"int":g=parseInt(g,10);break;case"float":g=parseFloat(g);break;default:break}}}}return g}function getColor(w,c,d,a,s){var b,f,g,h,u,e,l,t,q,k,n,v,r,m;var a=a||s.length>0;if(s.length>0){for(var p=0;p<s.length;p++){if(w>s[p].lo&&w<=s[p].hi){return s[p].color}}}b=d.length;if(b===1){return d[0]}f=(a)?(1/b):(1/(b-1));g=[];for(p=0;p<d.length;p++){h=(a)?(f*(p+1)):(f*p);u=parseInt((cutHex(d[p])).substring(0,2),16);e=parseInt((cutHex(d[p])).substring(2,4),16);l=parseInt((cutHex(d[p])).substring(4,6),16);g[p]={pct:h,color:{r:u,g:e,b:l}}}if(c===0){return"rgb("+[g[0].color.r,g[0].color.g,g[0].color.b].join(",")+")"}for(var o=0;o<g.length;o++){if(c<=g[o].pct){if(a){return"rgb("+[g[o].color.r,g[o].color.g,g[o].color.b].join(",")+")"}else{t=g[o-1];q=g[o];k=q.pct-t.pct;n=(c-t.pct)/k;v=1-n;r=n;m={r:Math.floor(t.color.r*v+q.color.r*r),g:Math.floor(t.color.g*v+q.color.g*r),b:Math.floor(t.color.b*v+q.color.b*r)};return"rgb("+[m.r,m.g,m.b].join(",")+")"}}}}function setDy(b,c,a){if((!ie||ie>9)&&b.node.firstChild.attributes.dy){b.node.firstChild.attributes.dy.value=0}}function getRandomInt(b,a){return Math.floor(Math.random()*(a-b+1))+b}function cutHex(a){return(a.charAt(0)=="#")?a.substring(1,7):a}function humanFriendlyNumber(g,f){var e,c,a,b;e=Math.pow;c=e(10,f);a=7;while(a){b=e(10,a--*3);if(b<=g){g=Math.round(g*c/b)/c+"KMGTPE"[a]}}return g}function formatNumber(a){var b=a.toString().split(".");b[0]=b[0].replace(/\B(?=(\d{3})+(?!\d))/g,",");return b.join(".")}function getStyle(a,b){var c="";if(document.defaultView&&document.defaultView.getComputedStyle){c=document.defaultView.getComputedStyle(a,"").getPropertyValue(b)}else{if(a.currentStyle){b=b.replace(/\-(\w)/g,function(d,e){return e.toUpperCase()});c=a.currentStyle[b]}}return c}function onCreateElementNsReady(a){if(document.createElementNS!==undefined){a()}else{setTimeout(function(){onCreateElementNsReady(a)},100)}}var ie=(function(){var c,a=3,d=document.createElement("div"),b=d.getElementsByTagName("i");while(d.innerHTML="<!--[if gt IE "+(++a)+"]><i></i><![endif]-->",b[0]){}return a>4?a:c}());function extend(a){a=a||{};for(var c=1;c<arguments.length;c++){if(!arguments[c]){continue}for(var b in arguments[c]){if(arguments[c].hasOwnProperty(b)){a[b]=arguments[c][b]}}}return a};