/*! cal-heatmap v3.6.2 (Mon Oct 10 2016 01:36:20)
 *  ---------------------------------------------
 *  Cal-Heatmap is a javascript module to create calendar heatmap to visualize time series data
 *  https://github.com/wa0x6e/cal-heatmap
 *  Licensed under the MIT license
 *  Copyright 2014 Wan Qi Chen
 */
;var d3=typeof require==="function"?require("d3"):window.d3;var CalHeatMap=function(){var c=this;this.allowedDataType=["json","csv","tsv","txt"];this.options={itemSelector:"#cal-heatmap",paintOnLoad:true,range:12,cellSize:10,cellPadding:2,cellRadius:0,domainGutter:2,domainMargin:[0,0,0,0],domain:"hour",subDomain:"min",colLimit:null,rowLimit:null,weekStartOnMonday:true,start:new Date(),minDate:null,maxDate:null,data:"",dataType:this.allowedDataType[0],dataPostPayload:null,considerMissingDataAsZero:false,loadOnInit:true,verticalOrientation:false,domainDynamicDimension:true,label:{position:"bottom",align:"center",offset:{x:0,y:0},rotate:null,width:100,height:null},legend:[10,20,30,40],displayLegend:true,legendCellSize:10,legendCellPadding:2,legendMargin:[0,0,0,0],legendVerticalPosition:"bottom",legendHorizontalPosition:"left",legendOrientation:"horizontal",legendColors:null,highlight:[],itemName:["item","items"],domainLabelFormat:null,subDomainTitleFormat:{empty:"{date}",filled:"{count} {name} {connector} {date}"},subDomainDateFormat:null,subDomainTextFormat:null,legendTitleFormat:{lower:"less than {min} {name}",inner:"between {down} and {up} {name}",upper:"more than {max} {name}"},animationDuration:500,nextSelector:false,previousSelector:false,itemNamespace:"cal-heatmap",tooltip:false,onClick:null,afterLoad:null,afterLoadNextDomain:null,afterLoadPreviousDomain:null,onComplete:null,afterLoadData:function(d){return d},onMaxDomainReached:null,onMinDomainReached:null};this._domainType={min:{name:"minute",level:10,maxItemNumber:60,defaultRowNumber:10,defaultColumnNumber:6,row:function(h){return c.getSubDomainRowNumber(h)},column:function(h){return c.getSubDomainColumnNumber(h)},position:{x:function(h){return Math.floor(h.getMinutes()/c._domainType.min.row(h))},y:function(h){return h.getMinutes()%c._domainType.min.row(h)}},format:{date:"%H:%M, %A %B %-e, %Y",legend:"",connector:"at"},extractUnit:function(h){return new Date(h.getFullYear(),h.getMonth(),h.getDate(),h.getHours(),h.getMinutes()).getTime()}},hour:{name:"hour",level:20,maxItemNumber:function(h){switch(c.options.domain){case"day":return 24;case"week":return 24*7;case"month":return 24*(c.options.domainDynamicDimension?c.getDayCountInMonth(h):31)}},defaultRowNumber:6,defaultColumnNumber:function(h){switch(c.options.domain){case"day":return 4;case"week":return 28;case"month":return c.options.domainDynamicDimension?c.getDayCountInMonth(h):31}},row:function(h){return c.getSubDomainRowNumber(h)},column:function(h){return c.getSubDomainColumnNumber(h)},position:{x:function(h){if(c.options.domain==="month"){if(c.options.colLimit>0||c.options.rowLimit>0){return Math.floor((h.getHours()+(h.getDate()-1)*24)/c._domainType.hour.row(h))}return Math.floor(h.getHours()/c._domainType.hour.row(h))+(h.getDate()-1)*4}else{if(c.options.domain==="week"){if(c.options.colLimit>0||c.options.rowLimit>0){return Math.floor((h.getHours()+c.getWeekDay(h)*24)/c._domainType.hour.row(h))}return Math.floor(h.getHours()/c._domainType.hour.row(h))+c.getWeekDay(h)*4}}return Math.floor(h.getHours()/c._domainType.hour.row(h))},y:function(i){var h=i.getHours();if(c.options.colLimit>0||c.options.rowLimit>0){switch(c.options.domain){case"month":h+=(i.getDate()-1)*24;break;case"week":h+=c.getWeekDay(i)*24;break}}return Math.floor(h%c._domainType.hour.row(i))}},format:{date:"%Hh, %A %B %-e, %Y",legend:"%H:00",connector:"at"},extractUnit:function(h){return new Date(h.getFullYear(),h.getMonth(),h.getDate(),h.getHours()).getTime()}},day:{name:"day",level:30,maxItemNumber:function(h){switch(c.options.domain){case"week":return 7;case"month":return c.options.domainDynamicDimension?c.getDayCountInMonth(h):31;case"year":return c.options.domainDynamicDimension?c.getDayCountInYear(h):366}},defaultColumnNumber:function(h){h=new Date(h);switch(c.options.domain){case"week":return 1;case"month":return(c.options.domainDynamicDimension&&!c.options.verticalOrientation)?(c.getWeekNumber(new Date(h.getFullYear(),h.getMonth()+1,0))-c.getWeekNumber(h)+1):6;case"year":return(c.options.domainDynamicDimension?(c.getWeekNumber(new Date(h.getFullYear(),11,31))-c.getWeekNumber(new Date(h.getFullYear(),0))+1):54)}},defaultRowNumber:7,row:function(h){return c.getSubDomainRowNumber(h)},column:function(h){return c.getSubDomainColumnNumber(h)},position:{x:function(h){switch(c.options.domain){case"week":return Math.floor(c.getWeekDay(h)/c._domainType.day.row(h));case"month":if(c.options.colLimit>0||c.options.rowLimit>0){return Math.floor((h.getDate()-1)/c._domainType.day.row(h))}return c.getWeekNumber(h)-c.getWeekNumber(new Date(h.getFullYear(),h.getMonth()));case"year":if(c.options.colLimit>0||c.options.rowLimit>0){return Math.floor((c.getDayOfYear(h)-1)/c._domainType.day.row(h))}return c.getWeekNumber(h)}},y:function(i){var h=c.getWeekDay(i);if(c.options.colLimit>0||c.options.rowLimit>0){switch(c.options.domain){case"year":h=c.getDayOfYear(i)-1;break;case"week":h=c.getWeekDay(i);break;case"month":h=i.getDate()-1;break}}return Math.floor(h%c._domainType.day.row(i))}},format:{date:"%A %B %-e, %Y",legend:"%e %b",connector:"on"},extractUnit:function(h){return new Date(h.getFullYear(),h.getMonth(),h.getDate()).getTime()}},week:{name:"week",level:40,maxItemNumber:54,defaultColumnNumber:function(h){h=new Date(h);switch(c.options.domain){case"year":return c._domainType.week.maxItemNumber;case"month":return c.options.domainDynamicDimension?c.getWeekNumber(new Date(h.getFullYear(),h.getMonth()+1,0))-c.getWeekNumber(h):5}},defaultRowNumber:1,row:function(h){return c.getSubDomainRowNumber(h)},column:function(h){return c.getSubDomainColumnNumber(h)},position:{x:function(h){switch(c.options.domain){case"year":return Math.floor(c.getWeekNumber(h)/c._domainType.week.row(h));case"month":return Math.floor(c.getMonthWeekNumber(h)/c._domainType.week.row(h))}},y:function(h){return c.getWeekNumber(h)%c._domainType.week.row(h)}},format:{date:"%B Week #%W",legend:"%B Week #%W",connector:"in"},extractUnit:function(j){var i=new Date(j.getFullYear(),j.getMonth(),j.getDate());var h=i.getDay()-(c.options.weekStartOnMonday?1:0);if(h<0){h=6}i.setDate(i.getDate()-h);return i.getTime()}},month:{name:"month",level:50,maxItemNumber:12,defaultColumnNumber:12,defaultRowNumber:1,row:function(){return c.getSubDomainRowNumber()},column:function(){return c.getSubDomainColumnNumber()},position:{x:function(h){return Math.floor(h.getMonth()/c._domainType.month.row(h))},y:function(h){return h.getMonth()%c._domainType.month.row(h)}},format:{date:"%B %Y",legend:"%B",connector:"in"},extractUnit:function(h){return new Date(h.getFullYear(),h.getMonth()).getTime()}},year:{name:"year",level:60,row:function(){return c.options.rowLimit||1},column:function(){return c.options.colLimit||1},position:{x:function(){return 1},y:function(){return 1}},format:{date:"%Y",legend:"%Y",connector:"in"},extractUnit:function(h){return new Date(h.getFullYear()).getTime()}}};for(var f in this._domainType){if(this._domainType.hasOwnProperty(f)){var g=this._domainType[f];this._domainType["x_"+f]={name:"x_"+f,level:g.type,maxItemNumber:g.maxItemNumber,defaultRowNumber:g.defaultRowNumber,defaultColumnNumber:g.defaultColumnNumber,row:g.column,column:g.row,position:{x:g.position.y,y:g.position.x},format:g.format,extractUnit:g.extractUnit}}}this.lastInsertedSvg=null;this._completed=false;this._domains=d3.map();this.graphDim={width:0,height:0};this.legendDim={width:0,height:0};this.NAVIGATE_LEFT=1;this.NAVIGATE_RIGHT=2;this.RESET_ALL_ON_UPDATE=0;this.RESET_SINGLE_ON_UPDATE=1;this.APPEND_ON_UPDATE=2;this.DEFAULT_LEGEND_MARGIN=10;this.root=null;this.tooltip=null;this._maxDomainReached=false;this._minDomainReached=false;this.domainPosition=new DomainPosition();this.Legend=null;this.legendScale=null;this.DSTDomain=[];this._init=function(){c.getDomain(c.options.start).map(function(h){return h.getTime()}).map(function(h){c._domains.set(h,c.getSubDomain(h).map(function(i){return{t:c._domainType[c.options.subDomain].extractUnit(i),v:null}}))});c.root=d3.select(c.options.itemSelector).append("svg").attr("class","cal-heatmap-container");c.tooltip=d3.select(c.options.itemSelector).attr("style",function(){var d=d3.select(c.options.itemSelector).attr("style");return(d!==null?d:"")+"position:relative;"}).append("div").attr("class","ch-tooltip");c.root.attr("x",0).attr("y",0).append("svg").attr("class","graph");c.Legend=new Legend(c);if(c.options.paintOnLoad){b()}return true};function b(){c.verticalDomainLabel=(c.options.label.position==="top"||c.options.label.position==="bottom");c.domainVerticalLabelHeight=c.options.label.height===null?Math.max(25,c.options.cellSize*2):c.options.label.height;c.domainHorizontalLabelWidth=0;if(c.options.domainLabelFormat===""&&c.options.label.height===null){c.domainVerticalLabelHeight=0}if(!c.verticalDomainLabel){c.domainVerticalLabelHeight=0;c.domainHorizontalLabelWidth=c.options.label.width}c.paint();if(c.options.nextSelector!==false){d3.select(c.options.nextSelector).on("click."+c.options.itemNamespace,function(){d3.event.preventDefault();return c.loadNextDomain(1)})}if(c.options.previousSelector!==false){d3.select(c.options.previousSelector).on("click."+c.options.itemNamespace,function(){d3.event.preventDefault();return c.loadPreviousDomain(1)})}c.Legend.redraw(c.graphDim.width-c.options.domainGutter-c.options.cellPadding);c.afterLoad();var d=c.getDomainKeys();if(c.options.loadOnInit){c.getDatas(c.options.data,new Date(d[0]),c.getSubDomain(d[d.length-1]).pop(),function(){c.fill();c.onComplete()})}else{c.onComplete()}c.checkIfMinDomainIsReached(d[0]);c.checkIfMaxDomainIsReached(c.getNextDomain().getTime())}function a(j,h){var i=c.options.cellSize*c._domainType[c.options.subDomain].column(j)+c.options.cellPadding*c._domainType[c.options.subDomain].column(j);if(arguments.length===2&&h===true){return i+=c.domainHorizontalLabelWidth+c.options.domainGutter+c.options.domainMargin[1]+c.options.domainMargin[3]}return i}function e(j,i){var h=c.options.cellSize*c._domainType[c.options.subDomain].row(j)+c.options.cellPadding*c._domainType[c.options.subDomain].row(j);if(arguments.length===2&&i===true){h+=c.options.domainGutter+c.domainVerticalLabelHeight+c.options.domainMargin[0]+c.options.domainMargin[2]}return h}this.paint=function(q){var r=c.options;if(arguments.length===0){q=false}var p=c.root.select(".graph").selectAll(".graph-domain").data(function(){var s=c.getDomainKeys();return q===c.NAVIGATE_LEFT?s.reverse():s},function(s){return s});var o=0;var d=0;var j=p.enter().append("svg").attr("width",function(s){return a(s,true)}).attr("height",function(s){return e(s,true)}).attr("x",function(s){if(r.verticalOrientation){c.graphDim.width=Math.max(c.graphDim.width,a(s,true));return 0}else{return n(s,c.graphDim,"width",a(s,true))}}).attr("y",function(s){if(r.verticalOrientation){return n(s,c.graphDim,"height",e(s,true))}else{c.graphDim.height=Math.max(c.graphDim.height,e(s,true));return 0}}).attr("class",function(u){var t="graph-domain";var s=new Date(u);switch(r.domain){case"hour":t+=" h_"+s.getHours();case"day":t+=" d_"+s.getDate()+" dy_"+s.getDay();case"week":t+=" w_"+c.getWeekNumber(s);case"month":t+=" m_"+(s.getMonth()+1);case"year":t+=" y_"+s.getFullYear()}return t});c.lastInsertedSvg=j;function n(w,t,v,s){var u=0;switch(q){case false:u=t[v];t[v]+=s;c.domainPosition.setPosition(w,u);return u;case c.NAVIGATE_RIGHT:c.domainPosition.setPosition(w,t[v]);o=s;d=c.domainPosition.getPositionFromIndex(1);c.domainPosition.shiftRightBy(d);return t[v];case c.NAVIGATE_LEFT:u=-s;o=-u;d=t[v]-c.domainPosition.getLast();c.domainPosition.setPosition(w,u);c.domainPosition.shiftLeftBy(o);return u}}j.append("rect").attr("width",function(s){return a(s,true)-r.domainGutter-r.cellPadding}).attr("height",function(s){return e(s,true)-r.domainGutter-r.cellPadding}).attr("class","domain-background");var i=j.append("svg").attr("x",function(){if(r.label.position==="left"){return c.domainHorizontalLabelWidth+r.domainMargin[3]}else{return r.domainMargin[3]}}).attr("y",function(){if(r.label.position==="top"){return c.domainVerticalLabelHeight+r.domainMargin[0]}else{return r.domainMargin[0]}}).attr("class","graph-subdomain-group");var m=i.selectAll("g").data(function(s){return c._domains.get(s)}).enter().append("g");m.append("rect").attr("class",function(s){return"graph-rect"+c.getHighlightClassName(s.t)+(r.onClick!==null?" hover_cursor":"")}).attr("width",r.cellSize).attr("height",r.cellSize).attr("x",function(s){return c.positionSubDomainX(s.t)}).attr("y",function(s){return c.positionSubDomainY(s.t)}).on("click",function(s){if(r.onClick!==null){return c.onClick(new Date(s.t),s.v)}}).call(function(s){if(r.cellRadius>0){s.attr("rx",r.cellRadius).attr("ry",r.cellRadius)}if(c.legendScale!==null&&r.legendColors!==null&&r.legendColors.hasOwnProperty("base")){s.attr("fill",r.legendColors.base)}if(r.tooltip){s.on("mouseover",function(w){var v=this.parentNode.parentNode;c.tooltip.html(c.getSubDomainTitle(w)).attr("style","display: block;");var u=c.positionSubDomainX(w.t)-c.tooltip[0][0].offsetWidth/2+r.cellSize/2;var t=c.positionSubDomainY(w.t)-c.tooltip[0][0].offsetHeight-r.cellSize/2;u+=parseInt(v.getAttribute("x"),10);t+=parseInt(v.getAttribute("y"),10);u+=parseInt(c.root.select(".graph").attr("x"),10);t+=parseInt(c.root.select(".graph").attr("y"),10);u+=parseInt(v.parentNode.getAttribute("x"),10);t+=parseInt(v.parentNode.getAttribute("y"),10);c.tooltip.attr("style","display: block; left: "+u+"px; top: "+t+"px;")});s.on("mouseout",function(){c.tooltip.attr("style","display:none").html("")})}});if(!r.tooltip){m.append("title").text(function(s){return c.formatDate(new Date(s.t),r.subDomainDateFormat)})}if(r.domainLabelFormat!==""){j.append("text").attr("class","graph-label").attr("y",function(s){var t=r.domainMargin[0];switch(r.label.position){case"top":t+=c.domainVerticalLabelHeight/2;break;case"bottom":t+=e(s)+c.domainVerticalLabelHeight/2}return t+r.label.offset.y*(((r.label.rotate==="right"&&r.label.position==="right")||(r.label.rotate==="left"&&r.label.position==="left"))?-1:1)}).attr("x",function(t){var s=r.domainMargin[3];switch(r.label.position){case"right":s+=a(t);break;case"bottom":case"top":s+=a(t)/2}if(r.label.align==="right"){return s+c.domainHorizontalLabelWidth-r.label.offset.x*(r.label.rotate==="right"?-1:1)}return s+r.label.offset.x}).attr("text-anchor",function(){switch(r.label.align){case"start":case"left":return"start";case"end":case"right":return"end";default:return"middle"}}).attr("dominant-baseline",function(){return c.verticalDomainLabel?"middle":"top"}).text(function(s){return c.formatDate(new Date(s),r.domainLabelFormat)}).call(k)}function k(s){switch(r.label.rotate){case"right":s.attr("transform",function(u){var t="rotate(90), ";switch(r.label.position){case"right":t+="translate(-"+a(u)+" , -"+a(u)+")";break;case"left":t+="translate(0, -"+c.domainHorizontalLabelWidth+")";break}return t});break;case"left":s.attr("transform",function(u){var t="rotate(270), ";switch(r.label.position){case"right":t+="translate(-"+(a(u)+c.domainHorizontalLabelWidth)+" , "+a(u)+")";break;case"left":t+="translate(-"+(c.domainHorizontalLabelWidth)+" , "+c.domainHorizontalLabelWidth+")";break}return t});break}}if(r.subDomainTextFormat!==null){m.append("text").attr("class",function(s){return"subdomain-text"+c.getHighlightClassName(s.t)}).attr("x",function(s){return c.positionSubDomainX(s.t)+r.cellSize/2}).attr("y",function(s){return c.positionSubDomainY(s.t)+r.cellSize/2}).attr("text-anchor","middle").attr("dominant-baseline","central").text(function(s){return c.formatDate(new Date(s.t),r.subDomainTextFormat)})}if(q!==false){p.transition().duration(r.animationDuration).attr("x",function(s){return r.verticalOrientation?0:c.domainPosition.getPosition(s)}).attr("y",function(s){return r.verticalOrientation?c.domainPosition.getPosition(s):0})}var h=c.graphDim.width;var l=c.graphDim.height;if(r.verticalOrientation){c.graphDim.height+=o-d}else{c.graphDim.width+=o-d}p.exit().transition().duration(r.animationDuration).attr("x",function(s){if(r.verticalOrientation){return 0}else{switch(q){case c.NAVIGATE_LEFT:return Math.min(c.graphDim.width,h);case c.NAVIGATE_RIGHT:return -a(s,true)}}}).attr("y",function(s){if(r.verticalOrientation){switch(q){case c.NAVIGATE_LEFT:return Math.min(c.graphDim.height,l);case c.NAVIGATE_RIGHT:return -e(s,true)}}else{return 0}}).remove();c.resize()}};CalHeatMap.prototype={init:function(d){var j=this;var p=j.options=mergeRecursive(j.options,d);n();i(p.itemSelector,false,"itemSelector");if(j.allowedDataType.indexOf(p.dataType)===-1){throw new Error("The data type '"+p.dataType+"' is not valid data type")}if(d3.select(p.itemSelector)[0][0]===null){throw new Error("The node '"+p.itemSelector+"' specified in itemSelector does not exists")}try{i(p.nextSelector,true,"nextSelector");i(p.previousSelector,true,"previousSelector")}catch(h){console.log(h.message);return false}if(!d.hasOwnProperty("subDomain")){this.options.subDomain=m(d.domain)}if(typeof p.itemNamespace!=="string"||p.itemNamespace===""){console.log("itemNamespace can not be empty, falling back to cal-heatmap");p.itemNamespace="cal-heatmap"}var o=["data","onComplete","onClick","afterLoad","afterLoadData","afterLoadPreviousDomain","afterLoadNextDomain"];for(var e in o){if(d.hasOwnProperty(o[e])){p[o[e]]=d[o[e]]}}p.subDomainDateFormat=(typeof p.subDomainDateFormat==="string"||typeof p.subDomainDateFormat==="function"?p.subDomainDateFormat:this._domainType[p.subDomain].format.date);p.domainLabelFormat=(typeof p.domainLabelFormat==="string"||typeof p.domainLabelFormat==="function"?p.domainLabelFormat:this._domainType[p.domain].format.legend);p.subDomainTextFormat=((typeof p.subDomainTextFormat==="string"&&p.subDomainTextFormat!=="")||typeof p.subDomainTextFormat==="function"?p.subDomainTextFormat:null);p.domainMargin=f(p.domainMargin);p.legendMargin=f(p.legendMargin);p.highlight=j.expandDateSetting(p.highlight);p.itemName=l(p.itemName);p.colLimit=a(p.colLimit);p.rowLimit=g(p.rowLimit);if(!d.hasOwnProperty("legendMargin")){b()}c();function i(k,r,q){if(((r&&k===false)||k instanceof Element||typeof k==="string")&&k!==""){return true}throw new Error("The "+q+" is not valid")}function m(k){switch(k){case"year":return"month";case"month":return"day";case"week":return"day";case"day":return"hour";default:return"min"}}function n(){if(!j._domainType.hasOwnProperty(p.domain)||p.domain==="min"||p.domain.substring(0,2)==="x_"){throw new Error("The domain '"+p.domain+"' is not valid")}if(!j._domainType.hasOwnProperty(p.subDomain)||p.subDomain==="year"){throw new Error("The subDomain '"+p.subDomain+"' is not valid")}if(j._domainType[p.domain].level<=j._domainType[p.subDomain].level){throw new Error("'"+p.subDomain+"' is not a valid subDomain to '"+p.domain+"'")}return true}function c(){if(!d.hasOwnProperty("label")||(d.hasOwnProperty("label")&&!d.label.hasOwnProperty("align"))){switch(p.label.position){case"left":p.label.align="right";break;case"right":p.label.align="left";break;default:p.label.align="center"}if(p.label.rotate==="left"){p.label.align="right"}else{if(p.label.rotate==="right"){p.label.align="left"}}}if(!d.hasOwnProperty("label")||(d.hasOwnProperty("label")&&!d.label.hasOwnProperty("offset"))){if(p.label.position==="left"||p.label.position==="right"){p.label.offset={x:10,y:15}}}}function b(){switch(p.legendVerticalPosition){case"top":p.legendMargin[2]=j.DEFAULT_LEGEND_MARGIN;break;case"bottom":p.legendMargin[0]=j.DEFAULT_LEGEND_MARGIN;break;case"middle":case"center":p.legendMargin[p.legendHorizontalPosition==="right"?3:1]=j.DEFAULT_LEGEND_MARGIN}}function f(k){if(typeof k==="number"){k=[k]}if(!Array.isArray(k)){console.log("Margin only takes an integer or an array of integers");k=[0]}switch(k.length){case 1:return[k[0],k[0],k[0],k[0]];case 2:return[k[0],k[1],k[0],k[1]];case 3:return[k[0],k[1],k[2],k[1]];case 4:return k;default:return k.slice(0,4)}}function l(k){if(typeof k==="string"){return[k,k+(k!==""?"s":"")]}if(Array.isArray(k)){if(k.length===1){return[k[0],k[0]+"s"]}else{if(k.length>2){return k.slice(0,2)}}return k}return["item","items"]}function a(k){return k>0?k:null}function g(k){if(k>0&&p.colLimit>0){console.log("colLimit and rowLimit are mutually exclusive, rowLimit will be ignored");return null}return k>0?k:null}return this._init()},expandDateSetting:function(a){if(!Array.isArray(a)){a=[a]}return a.map(function(b){if(b==="now"){return new Date()}if(b instanceof Date){return b}return false}).filter(function(b){return b!==false})},fill:function(a){var e=this;var c=e.options;if(arguments.length===0){a=e.root.selectAll(".graph-domain")}var f=a.selectAll("svg").selectAll("g").data(function(g){return e._domains.get(g)});function d(g){if(e.legendScale===null){return false}g.attr("fill",function(h){if(h.v===null&&(c.hasOwnProperty("considerMissingDataAsZero")&&!c.considerMissingDataAsZero)){if(c.legendColors.hasOwnProperty("base")){return c.legendColors.base}}if(c.legendColors!==null&&c.legendColors.hasOwnProperty("empty")&&(h.v===0||(h.v===null&&c.hasOwnProperty("considerMissingDataAsZero")&&c.considerMissingDataAsZero))){return c.legendColors.empty}if(h.v<0&&c.legend[0]>0&&c.legendColors!==null&&c.legendColors.hasOwnProperty("overflow")){return c.legendColors.overflow}return e.legendScale(Math.min(h.v,c.legend[c.legend.length-1]))})}f.transition().duration(c.animationDuration).select("rect").attr("class",function(j){var h=e.getHighlightClassName(j.t).trim().split(" ");var g=e.dateIsLessThan(j.t,new Date());var i=e.dateIsEqual(j.t,new Date());if(e.legendScale===null||(j.v===null&&(c.hasOwnProperty("considerMissingDataAsZero")&&!c.considerMissingDataAsZero)&&!c.legendColors.hasOwnProperty("base"))){h.push("graph-rect")}if(i){h.push("now")}else{if(!g){h.push("future")}}if(j.v!==null){h.push(e.Legend.getClass(j.v,(e.legendScale===null)))}else{if(c.considerMissingDataAsZero&&g){h.push(e.Legend.getClass(0,(e.legendScale===null)))}}if(c.onClick!==null){h.push("hover_cursor")}return h.join(" ")}).call(d);f.transition().duration(c.animationDuration).select("title").text(function(g){return e.getSubDomainTitle(g)});function b(g){if(typeof c.subDomainTextFormat==="function"){g.text(function(h){return c.subDomainTextFormat(h.t,h.v)})}}f.transition().duration(c.animationDuration).select("text").attr("class",function(g){return"subdomain-text"+e.getHighlightClassName(g.t)}).call(b)},triggerEvent:function(a,b,c){if((arguments.length===3&&c)||this.options[a]===null){return true}if(typeof this.options[a]==="function"){if(typeof b==="function"){b=b()}return this.options[a].apply(this,b)}else{console.log("Provided callback for "+a+" is not a function.");return false}},onClick:function(a,b){return this.triggerEvent("onClick",[a,b])},afterLoad:function(){return this.triggerEvent("afterLoad")},onComplete:function(){var a=this.triggerEvent("onComplete",[],this._completed);this._completed=true;return a},afterLoadPreviousDomain:function(b){var a=this;return this.triggerEvent("afterLoadPreviousDomain",function(){var c=a.getSubDomain(b);return[c.shift(),c.pop()]})},afterLoadNextDomain:function(b){var a=this;return this.triggerEvent("afterLoadNextDomain",function(){var c=a.getSubDomain(b);return[c.shift(),c.pop()]})},onMinDomainReached:function(a){this._minDomainReached=a;return this.triggerEvent("onMinDomainReached",[a])},onMaxDomainReached:function(a){this._maxDomainReached=a;return this.triggerEvent("onMaxDomainReached",[a])},checkIfMinDomainIsReached:function(a,b){if(this.minDomainIsReached(a)){this.onMinDomainReached(true)}if(arguments.length===2){if(this._maxDomainReached&&!this.maxDomainIsReached(b)){this.onMaxDomainReached(false)}}},checkIfMaxDomainIsReached:function(a,b){if(this.maxDomainIsReached(a)){this.onMaxDomainReached(true)}if(arguments.length===2){if(this._minDomainReached&&!this.minDomainIsReached(b)){this.onMinDomainReached(false)}}},formatNumber:d3.format(",g"),formatDate:function(c,b){if(arguments.length<2){b="title"}if(typeof b==="function"){return b(c)}else{var a=d3.time.format(b);return a(c)}},getSubDomainTitle:function(b){if(b.v===null&&!this.options.considerMissingDataAsZero){return(this.options.subDomainTitleFormat.empty).format({date:this.formatDate(new Date(b.t),this.options.subDomainDateFormat)})}else{var a=b.v;if(a===null&&this.options.considerMissingDataAsZero){a=0}return(this.options.subDomainTitleFormat.filled).format({count:this.formatNumber(a),name:this.options.itemName[(a!==1?1:0)],connector:this._domainType[this.options.subDomain].format.connector,date:this.formatDate(new Date(b.t),this.options.subDomainDateFormat)})}},loadNextDomain:function(b){if(this._maxDomainReached||b===0){return false}var a=this.loadNewDomains(this.NAVIGATE_RIGHT,this.getDomain(this.getNextDomain(),b));this.afterLoadNextDomain(a.end);this.checkIfMaxDomainIsReached(this.getNextDomain().getTime(),a.start);return true},loadPreviousDomain:function(b){if(this._minDomainReached||b===0){return false}var a=this.loadNewDomains(this.NAVIGATE_LEFT,this.getDomain(this.getDomainKeys()[0],-b).reverse());this.afterLoadPreviousDomain(a.start);this.checkIfMinDomainIsReached(a.start,a.end);return true},loadNewDomains:function(g,f){var d=this;var h=g===this.NAVIGATE_LEFT;var c=-1;var e=f.length;var a=this.getDomainKeys();function b(i){return{t:d._domainType[d.options.subDomain].extractUnit(i),v:null}}while(++c<e){if(h&&this.minDomainIsReached(f[c])){f=f.slice(0,c+1);break}if(!h&&this.maxDomainIsReached(f[c])){f=f.slice(0,c);break}}f=f.slice(-this.options.range);for(c=0,e=f.length;c<e;c++){this._domains.set(f[c].getTime(),this.getSubDomain(f[c]).map(b));this._domains.remove(h?a.pop():a.shift())}a=this.getDomainKeys();if(h){f=f.reverse()}this.paint(g);this.getDatas(this.options.data,f[0],this.getSubDomain(f[f.length-1]).pop(),function(){d.fill(d.lastInsertedSvg)});return{start:f[h?0:1],end:a[a.length-1]}},maxDomainIsReached:function(a){return(this.options.maxDate!==null&&(this.options.maxDate.getTime()<a))},minDomainIsReached:function(a){return(this.options.minDate!==null&&(this.options.minDate.getTime()>=a))},getDomainKeys:function(){return this._domains.keys().map(function(a){return parseInt(a,10)}).sort(function(d,c){return d-c})},positionSubDomainX:function(b){var a=this._domainType[this.options.subDomain].position.x(new Date(b));return a*this.options.cellSize+a*this.options.cellPadding},positionSubDomainY:function(b){var a=this._domainType[this.options.subDomain].position.y(new Date(b));return a*this.options.cellSize+a*this.options.cellPadding},getSubDomainColumnNumber:function(c){if(this.options.rowLimit>0){var b=this._domainType[this.options.subDomain].maxItemNumber;if(typeof b==="function"){b=b(c)}return Math.ceil(b/this.options.rowLimit)}var a=this._domainType[this.options.subDomain].defaultColumnNumber;if(typeof a==="function"){a=a(c)}return this.options.colLimit||a},getSubDomainRowNumber:function(c){if(this.options.colLimit>0){var b=this._domainType[this.options.subDomain].maxItemNumber;if(typeof b==="function"){b=b(c)}return Math.ceil(b/this.options.colLimit)}var a=this._domainType[this.options.subDomain].defaultRowNumber;if(typeof a==="function"){a=a(c)}return this.options.rowLimit||a},getHighlightClassName:function(b){b=new Date(b);if(this.options.highlight.length>0){for(var a in this.options.highlight){if(this.dateIsEqual(this.options.highlight[a],b)){return this.isNow(this.options.highlight[a])?" highlight-now":" highlight"}}}return""},isNow:function(a){return this.dateIsEqual(a,new Date())},dateIsEqual:function(b,a){if(!(b instanceof Date)){b=new Date(b)}if(!(a instanceof Date)){a=new Date(a)}switch(this.options.subDomain){case"x_min":case"min":return b.getFullYear()===a.getFullYear()&&b.getMonth()===a.getMonth()&&b.getDate()===a.getDate()&&b.getHours()===a.getHours()&&b.getMinutes()===a.getMinutes();case"x_hour":case"hour":return b.getFullYear()===a.getFullYear()&&b.getMonth()===a.getMonth()&&b.getDate()===a.getDate()&&b.getHours()===a.getHours();case"x_day":case"day":return b.getFullYear()===a.getFullYear()&&b.getMonth()===a.getMonth()&&b.getDate()===a.getDate();case"x_week":case"week":return b.getFullYear()===a.getFullYear()&&this.getWeekNumber(b)===this.getWeekNumber(a);case"x_month":case"month":return b.getFullYear()===a.getFullYear()&&b.getMonth()===a.getMonth();default:return false}},dateIsLessThan:function(b,a){if(!(b instanceof Date)){b=new Date(b)}if(!(a instanceof Date)){a=new Date(a)}function c(d,e){switch(e){case"x_min":case"min":return new Date(d.getFullYear(),d.getMonth(),d.getDate(),d.getHours(),d.getMinutes()).getTime();case"x_hour":case"hour":return new Date(d.getFullYear(),d.getMonth(),d.getDate(),d.getHours()).getTime();case"x_day":case"day":return new Date(d.getFullYear(),d.getMonth(),d.getDate()).getTime();case"x_week":case"week":case"x_month":case"month":return new Date(d.getFullYear(),d.getMonth()).getTime();default:return d.getTime()}}return c(b,this.options.subDomain)<c(a,this.options.subDomain)},getDayOfYear:d3.time.format("%j"),getWeekNumber:function(b){var a=this.options.weekStartOnMonday===true?d3.time.format("%W"):d3.time.format("%U");return a(b)},getMonthWeekNumber:function(b){if(typeof b==="number"){b=new Date(b)}var a=this.getWeekNumber(new Date(b.getFullYear(),b.getMonth()));return this.getWeekNumber(b)-a-1},getWeekNumberInYear:function(a){if(typeof a==="number"){a=new Date(a)}},getDayCountInMonth:function(a){return this.getEndOfMonth(a).getDate()},getDayCountInYear:function(a){if(typeof a==="number"){a=new Date(a)}return(new Date(a.getFullYear(),1,29).getMonth()===1)?366:365},getWeekDay:function(a){if(this.options.weekStartOnMonday===false){return a.getDay()}return a.getDay()===0?6:(a.getDay()-1)},getEndOfMonth:function(a){if(typeof a==="number"){a=new Date(a)}return new Date(a.getFullYear(),a.getMonth()+1,0)},jumpDate:function(a,c,b){var e=new Date(a);switch(b){case"hour":e.setHours(e.getHours()+c);break;case"day":e.setHours(e.getHours()+c*24);break;case"week":e.setHours(e.getHours()+c*24*7);break;case"month":e.setMonth(e.getMonth()+c);break;case"year":e.setFullYear(e.getFullYear()+c)}return new Date(e)},getMinuteDomain:function(c,a){var e=new Date(c.getFullYear(),c.getMonth(),c.getDate(),c.getHours());var b=null;if(a instanceof Date){b=new Date(a.getFullYear(),a.getMonth(),a.getDate(),a.getHours())}else{b=new Date(+e+a*1000*60)}return d3.time.minutes(Math.min(e,b),Math.max(e,b))},getHourDomain:function(g,b){var h=new Date(g.getFullYear(),g.getMonth(),g.getDate(),g.getHours());var e=null;if(b instanceof Date){e=new Date(b.getFullYear(),b.getMonth(),b.getDate(),b.getHours())}else{e=new Date(h);e.setHours(e.getHours()+b)}var a=d3.time.hours(Math.min(h,e),Math.max(h,e));var c=0;var f=a.length;for(c=0;c<f;c++){if(c>0&&(a[c].getHours()===a[c-1].getHours())){this.DSTDomain.push(a[c].getTime());a.splice(c,1);break}}if(typeof b==="number"&&a.length>Math.abs(b)){a.splice(a.length-1,1)}return a},getDayDomain:function(c,a){var e=new Date(c.getFullYear(),c.getMonth(),c.getDate());var b=null;if(a instanceof Date){b=new Date(a.getFullYear(),a.getMonth(),a.getDate())}else{b=new Date(e);b=new Date(b.setDate(b.getDate()+parseInt(a,10)))}return d3.time.days(Math.min(e,b),Math.max(e,b))},getWeekDomain:function(f,b){var a;if(this.options.weekStartOnMonday===false){a=new Date(f.getFullYear(),f.getMonth(),f.getDate()-f.getDay())}else{if(f.getDay()===1){a=new Date(f.getFullYear(),f.getMonth(),f.getDate())}else{if(f.getDay()===0){a=new Date(f.getFullYear(),f.getMonth(),f.getDate());a.setDate(a.getDate()-6)}else{a=new Date(f.getFullYear(),f.getMonth(),f.getDate()-f.getDay()+1)}}}var e=new Date(a);var c=b;if(typeof b!=="object"){c=new Date(e.setDate(e.getDate()+b*7))}return(this.options.weekStartOnMonday===true)?d3.time.mondays(Math.min(a,c),Math.max(a,c)):d3.time.sundays(Math.min(a,c),Math.max(a,c))},getMonthDomain:function(c,a){var e=new Date(c.getFullYear(),c.getMonth());var b=null;if(a instanceof Date){b=new Date(a.getFullYear(),a.getMonth())}else{b=new Date(e);b=b.setMonth(b.getMonth()+a)}return d3.time.months(Math.min(e,b),Math.max(e,b))},getYearDomain:function(c,a){var e=new Date(c.getFullYear(),0);var b=null;if(a instanceof Date){b=new Date(a.getFullYear(),0)}else{b=new Date(c.getFullYear()+a,0)}return d3.time.years(Math.min(e,b),Math.max(e,b))},getDomain:function(c,b){if(typeof c==="number"){c=new Date(c)}if(arguments.length<2){b=this.options.range}switch(this.options.domain){case"hour":var a=this.getHourDomain(c,b);if(typeof b==="number"&&a.length<b){if(b>0){a.push(this.getHourDomain(a[a.length-1],2)[1])}else{a.shift(this.getHourDomain(a[0],-2)[0])}}return a;case"day":return this.getDayDomain(c,b);case"week":return this.getWeekDomain(c,b);case"month":return this.getMonthDomain(c,b);case"year":return this.getYearDomain(c,b)}},getSubDomain:function(c){if(typeof c==="number"){c=new Date(c)}var d=this;var b=function(g,h){switch(h){case"year":return d.getDayCountInYear(g);case"month":return d.getDayCountInMonth(g);case"week":return 7}};var f=function(g,h){switch(h){case"hour":return 60;case"day":return 60*24;case"week":return 60*24*7}};var a=function(g,h){switch(h){case"day":return 24;case"week":return 168;case"month":return d.getDayCountInMonth(g)*24}};var e=function(g,j){if(j==="month"){var k=new Date(g.getFullYear(),g.getMonth()+1,0);var i=d.getWeekNumber(k);var h=d.getWeekNumber(new Date(g.getFullYear(),g.getMonth()));if(h>i){h=0;i++}return i-h+1}else{if(j==="year"){return d.getWeekNumber(new Date(g.getFullYear(),11,31))}}};switch(this.options.subDomain){case"x_min":case"min":return this.getMinuteDomain(c,f(c,this.options.domain));case"x_hour":case"hour":return this.getHourDomain(c,a(c,this.options.domain));case"x_day":case"day":return this.getDayDomain(c,b(c,this.options.domain));case"x_week":case"week":return this.getWeekDomain(c,e(c,this.options.domain));case"x_month":case"month":return this.getMonthDomain(c,12)}},getNextDomain:function(a){if(arguments.length===0){a=1}return this.getDomain(this.jumpDate(this.getDomainKeys().pop(),a,this.options.domain),1)[0]},getPreviousDomain:function(a){if(arguments.length===0){a=1}return this.getDomain(this.jumpDate(this.getDomainKeys().shift(),-a,this.options.domain),1)[0]},getDatas:function(a,c,d,i,h,f){var j=this;if(arguments.length<5){h=true}if(arguments.length<6){f=this.APPEND_ON_UPDATE}var k=function(l){if(h!==false){if(typeof h==="function"){l=h(l)}else{if(typeof(j.options.afterLoadData)==="function"){l=j.options.afterLoadData(l)}else{console.log("Provided callback for afterLoadData is not a function.")}}}else{if(j.options.dataType==="csv"||j.options.dataType==="tsv"){l=this.interpretCSV(l)}}j.parseDatas(l,f,c,d);if(typeof i==="function"){i()}};switch(typeof a){case"string":if(a===""){k({});return true}else{var b=this.parseURI(a,c,d);var e="GET";if(j.options.dataPostPayload!==null){e="POST"}var g=null;if(j.options.dataPostPayload!==null){g=this.parseURI(j.options.dataPostPayload,c,d)}switch(this.options.dataType){case"json":d3.json(b,k).send(e,g);break;case"csv":d3.csv(b,k).send(e,g);break;case"tsv":d3.tsv(b,k).send(e,g);break;case"txt":d3.text(b,"text/plain",k).send(e,g);break}}return false;case"object":if(a===Object(a)){k(a);return false}default:k({});return true}},parseDatas:function(c,i,a,f){if(i===this.RESET_ALL_ON_UPDATE){this._domains.forEach(function(d,m){m.forEach(function(o,n,p){p[n].v=null})})}var j={};var l=function(m){return m.t};for(var h in c){var b=new Date(h*1000);var k=this.getDomain(b)[0].getTime();if(this.DSTDomain.indexOf(k)>=0){if(this._domains.has(k-3600*1000)){k-=3600*1000}}if(isNaN(h)||!c.hasOwnProperty(h)||!this._domains.has(k)||!(k>=+a&&k<+f)){continue}var e=this._domains.get(k);if(!j.hasOwnProperty(k)){j[k]=e.map(l)}var g=j[k].indexOf(this._domainType[this.options.subDomain].extractUnit(b));if(i===this.RESET_SINGLE_ON_UPDATE){e[g].v=c[h]}else{if(!isNaN(e[g].v)){e[g].v+=c[h]}else{e[g].v=c[h]}}}},parseURI:function(c,a,b){c=c.replace(/\{\{t:start\}\}/g,a.getTime()/1000);c=c.replace(/\{\{t:end\}\}/g,b.getTime()/1000);c=c.replace(/\{\{d:start\}\}/g,a.toISOString());c=c.replace(/\{\{d:end\}\}/g,b.toISOString());return c},interpretCSV:function(e){var f={};var c=Object.keys(e[0]);var a,b;for(a=0,b=e.length;a<b;a++){f[e[a][c[0]]]=+e[a][c[1]]}return f},resize:function(){var d=this;var c=d.options;var e=c.displayLegend?(d.Legend.getDim("width")+c.legendMargin[1]+c.legendMargin[3]):0;var a=c.displayLegend?(d.Legend.getDim("height")+c.legendMargin[0]+c.legendMargin[2]):0;var f=d.graphDim.width-c.domainGutter-c.cellPadding;var b=d.graphDim.height-c.domainGutter-c.cellPadding;this.root.transition().duration(c.animationDuration).attr("width",function(){if(c.legendVerticalPosition==="middle"||c.legendVerticalPosition==="center"){return f+e}return Math.max(f,e)}).attr("height",function(){if(c.legendVerticalPosition==="middle"||c.legendVerticalPosition==="center"){return Math.max(b,a)}return b+a});this.root.select(".graph").transition().duration(c.animationDuration).attr("y",function(){if(c.legendVerticalPosition==="top"){return a}return 0}).attr("x",function(){if((c.legendVerticalPosition==="middle"||c.legendVerticalPosition==="center")&&c.legendHorizontalPosition==="left"){return e}return 0})},next:function(a){if(arguments.length===0){a=1}return this.loadNextDomain(a)},previous:function(a){if(arguments.length===0){a=1}return this.loadPreviousDomain(a)},jumpTo:function(c,d){if(arguments.length<2){d=false}var a=this.getDomainKeys();var e=a[0];var b=a[a.length-1];if(c<e){return this.loadPreviousDomain(this.getDomain(e,c).length)}else{if(d){return this.loadNextDomain(this.getDomain(e,c).length)}if(c>b){return this.loadNextDomain(this.getDomain(b,c).length)}}return false},rewind:function(){this.jumpTo(this.options.start,true)},update:function(e,d,c){if(arguments.length<2){d=true}if(arguments.length<3){c=this.RESET_ALL_ON_UPDATE}var a=this.getDomainKeys();var b=this;this.getDatas(e,new Date(a[0]),this.getSubDomain(a[a.length-1]).pop(),function(){b.fill()},d,c)},setLegend:function(){var a=this.options.legend.slice(0);if(arguments.length>=1&&Array.isArray(arguments[0])){this.options.legend=arguments[0]}if(arguments.length>=2){if(Array.isArray(arguments[1])&&arguments[1].length>=2){this.options.legendColors=[arguments[1][0],arguments[1][1]]}else{this.options.legendColors=arguments[1]}}if((arguments.length>0&&!arrayEquals(a,this.options.legend))||arguments.length>=2){this.Legend.buildColors();this.fill()}this.Legend.redraw(this.graphDim.width-this.options.domainGutter-this.options.cellPadding)},removeLegend:function(){if(!this.options.displayLegend){return false}this.options.displayLegend=false;this.Legend.remove();return true},showLegend:function(){if(this.options.displayLegend){return false}this.options.displayLegend=true;this.Legend.redraw(this.graphDim.width-this.options.domainGutter-this.options.cellPadding);return true},highlight:function(a){if((this.options.highlight=this.expandDateSetting(a)).length>0){this.fill();return true}return false},destroy:function(a){this.root.transition().duration(this.options.animationDuration).attr("width",0).attr("height",0).remove().each("end",function(){if(typeof a==="function"){a()}else{if(typeof a!=="undefined"){console.log("Provided callback for destroy() is not a function.")}}});return null},getSVG:function(){var v={".cal-heatmap-container":{},".graph":{},".graph-rect":{},"rect.highlight":{},"rect.now":{},"rect.highlight-now":{},"text.highlight":{},"text.now":{},"text.highlight-now":{},".domain-background":{},".graph-label":{},".subdomain-text":{},".q0":{},".qi":{}};for(var h=1,t=this.options.legend.length+1;h<=t;h++){v[".q"+h]={}}var u=this.root;var o=["stroke","stroke-width","stroke-opacity","stroke-dasharray","stroke-dashoffset","stroke-linecap","stroke-miterlimit","fill","fill-opacity","fill-rule","marker","marker-start","marker-mid","marker-end","alignement-baseline","baseline-shift","dominant-baseline","glyph-orientation-horizontal","glyph-orientation-vertical","kerning","text-anchor","shape-rendering","text-transform","font-family","font","font-size","font-weight"];var b=function(i,k,j){if(o.indexOf(k)!==-1){v[i][k]=j}};var d=function(i){return u.select(i)[0][0]};for(var n in v){if(!v.hasOwnProperty(n)){continue}var g=d(n);if(g===null){continue}if("getComputedStyle" in window){var s=getComputedStyle(g,null);if(s.length!==0){for(var m=0;m<s.length;m++){b(n,s.item(m),s.getPropertyValue(s.item(m)))}}else{for(var f in s){if(s.hasOwnProperty(f)){b(n,f,s[f])}}}}else{if("currentStyle" in g){var r=g.currentStyle;for(var c in r){b(n,c,r[c])}}}}var q='<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><style type="text/css"><![CDATA[ ';for(var a in v){q+=a+" {\n";for(var e in v[a]){q+="\t"+e+":"+v[a][e]+";\n"}q+="}\n"}q+="]]></style>";q+=new XMLSerializer().serializeToString(this.root[0][0]);q+="</svg>";return q}};var DomainPosition=function(){this.positions=d3.map()};DomainPosition.prototype.getPosition=function(a){return this.positions.get(a)};DomainPosition.prototype.getPositionFromIndex=function(b){var a=this.getKeys();return this.positions.get(a[b])};DomainPosition.prototype.getLast=function(){var a=this.getKeys();return this.positions.get(a[a.length-1])};DomainPosition.prototype.setPosition=function(b,a){this.positions.set(b,a)};DomainPosition.prototype.shiftRightBy=function(b){this.positions.forEach(function(c,d){this.set(c,d-b)});var a=this.getKeys();this.positions.remove(a[0])};DomainPosition.prototype.shiftLeftBy=function(b){this.positions.forEach(function(c,d){this.set(c,d+b)});var a=this.getKeys();this.positions.remove(a[a.length-1])};DomainPosition.prototype.getKeys=function(){return this.positions.keys().sort(function(d,c){return parseInt(d,10)-parseInt(c,10)})};var Legend=function(a){this.calendar=a;this.computeDim();if(a.options.legendColors!==null){this.buildColors()}};Legend.prototype.computeDim=function(){var a=this.calendar.options;this.dim={width:a.legendCellSize*(a.legend.length+1)+a.legendCellPadding*(a.legend.length),height:a.legendCellSize}};Legend.prototype.remove=function(){this.calendar.root.select(".graph-legend").remove();this.calendar.resize()};Legend.prototype.redraw=function(a){if(!this.calendar.options.displayLegend){return false}var i=this;var e=this.calendar;var j=e.root;var f;var k=e.options;this.computeDim();var c=k.legend.slice(0);c.push(c[c.length-1]+1);var d=e.root.select(".graph-legend");if(d[0][0]!==null){j=d;f=j.select("g").selectAll("rect").data(c)}else{j=k.legendVerticalPosition==="top"?j.insert("svg",".graph"):j.append("svg");j.attr("x",g()).attr("y",b());f=j.attr("class","graph-legend").attr("height",i.getDim("height")).attr("width",i.getDim("width")).append("g").selectAll().data(c)}f.enter().append("rect").call(h).attr("class",function(l){return e.Legend.getClass(l,(e.legendScale===null))}).attr("fill-opacity",0).call(function(l){if(e.legendScale!==null&&k.legendColors!==null&&k.legendColors.hasOwnProperty("base")){l.attr("fill",k.legendColors.base)}}).append("title");f.exit().transition().duration(k.animationDuration).attr("fill-opacity",0).remove();f.transition().delay(function(m,l){return k.animationDuration*l/10}).call(h).attr("fill-opacity",1).call(function(l){l.attr("fill",function(n,m){if(e.legendScale===null){return""}if(m===0){return e.legendScale(n-1)}return e.legendScale(k.legend[m-1])});l.attr("class",function(m){return e.Legend.getClass(m,(e.legendScale===null))})});function h(l){l.attr("width",k.legendCellSize).attr("height",k.legendCellSize).attr("x",function(n,m){return m*(k.legendCellSize+k.legendCellPadding)})}f.select("title").text(function(m,l){if(l===0){return(k.legendTitleFormat.lower).format({min:k.legend[l],name:k.itemName[1]})}else{if(l===c.length-1){return(k.legendTitleFormat.upper).format({max:k.legend[l-1],name:k.itemName[1]})}else{return(k.legendTitleFormat.inner).format({down:k.legend[l-1],up:k.legend[l],name:k.itemName[1]})}}});j.transition().duration(k.animationDuration).attr("x",g()).attr("y",b()).attr("width",i.getDim("width")).attr("height",i.getDim("height"));j.select("g").transition().duration(k.animationDuration).attr("transform",function(){if(k.legendOrientation==="vertical"){return"rotate(90 "+k.legendCellSize/2+" "+k.legendCellSize/2+")"}return""});function g(){switch(k.legendHorizontalPosition){case"right":if(k.legendVerticalPosition==="center"||k.legendVerticalPosition==="middle"){return a+k.legendMargin[3]}return a-i.getDim("width")-k.legendMargin[1];case"middle":case"center":return Math.round(a/2-i.getDim("width")/2);default:return k.legendMargin[3]}}function b(){if(k.legendVerticalPosition==="bottom"){return e.graphDim.height+k.legendMargin[0]-k.domainGutter-k.cellPadding}return k.legendMargin[0]}e.resize()};Legend.prototype.getDim=function(a){var b=(this.calendar.options.legendOrientation==="horizontal");switch(a){case"width":return this.dim[b?"width":"height"];case"height":return this.dim[b?"height":"width"]}};Legend.prototype.buildColors=function(){var b=this.calendar.options;if(b.legendColors===null){this.calendar.legendScale=null;return false}var d=[];if(Array.isArray(b.legendColors)){d=b.legendColors}else{if(b.legendColors.hasOwnProperty("min")&&b.legendColors.hasOwnProperty("max")){d=[b.legendColors.min,b.legendColors.max]}else{b.legendColors=null;return false}}var e=b.legend.slice(0);if(e[0]>0){e.unshift(0)}else{if(e[0]<0){e.unshift(e[0]-(e[e.length-1]-e[0])/e.length)}}var c=d3.scale.linear().range(d).interpolate(d3.interpolateHcl).domain([d3.min(e),d3.max(e)]);var a=e.map(function(f){return c(f)});this.calendar.legendScale=d3.scale.threshold().domain(b.legend).range(a);return true};Legend.prototype.getClass=function(e,d){if(e===null||isNaN(e)){return""}var a=[this.calendar.options.legend.length+1];for(var b=0,c=this.calendar.options.legend.length-1;b<=c;b++){if(this.calendar.options.legend[0]>0&&e<0){a=["1","i"];break}if(e<=this.calendar.options.legend[b]){a=[b+1];break}}if(e===0){a.push(0)}a.unshift("");return(a.join(" r")+(d?a.join(" q"):"")).trim()};String.prototype.format=function(){var b=this;for(var c in arguments[0]){if(arguments[0].hasOwnProperty(c)){var a=new RegExp("\\{"+c+"\\}","gi");b=b.replace(a,arguments[0][c])}}return b};function mergeRecursive(d,c){for(var b in c){try{if(c[b].constructor===Object){d[b]=mergeRecursive(d[b],c[b])}else{d[b]=c[b]}}catch(a){d[b]=c[b]}}return d}function arrayEquals(b,a){if(!a||!b){return false}if(b.length!==a.length){return false}for(var c=0;c<b.length;c++){if(b[c] instanceof Array&&a[c] instanceof Array){if(!arrayEquals(b[c],a[c])){return false}}else{if(b[c]!==a[c]){return false}}}return true}if(typeof define==="function"&&define.amd){define(["d3"],function(){return CalHeatMap})}else{if(typeof module==="object"&&module.exports){module.exports=CalHeatMap}else{window.CalHeatMap=CalHeatMap}};